/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanBitCode;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanParams;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class HuffmanCanoncialCodeGenerator<T> {
    private final HuffmanParams<T> huffmanParams;
    private final List<HuffmanBitCode<T>> huffmanBitCodesByBitLengthThenCode;
    private final Map<T, HuffmanBitCode<T>> huffmanBitCodesBySymbol;
    private final List<T> symbolsSortedByBitCode;
    private final int[] bitLensSortedByBitCode;
    private final int[] bitCodeToSymbol;
    private final Comparator<HuffmanBitCode<T>> bitCodeComparator = (o1, o2) -> {
        int result = o1.getCodeWordBitLength() - o2.getCodeWordBitLength();
        if (result == 0) {
            return o1.getCodeWord() - o2.getCodeWord();
        }
        return result;
    };

    public HuffmanCanoncialCodeGenerator(HuffmanParams<T> huffmanParams) {
        int i2;
        ValidationUtils.nonNull(huffmanParams, "requires huffman params");
        this.huffmanParams = huffmanParams;
        this.huffmanBitCodesByBitLengthThenCode = this.getCanonicalCodeWords();
        int nSymbols = this.huffmanBitCodesByBitLengthThenCode.size();
        this.huffmanBitCodesBySymbol = new HashMap<T, HuffmanBitCode<T>>(nSymbols);
        this.huffmanBitCodesByBitLengthThenCode.forEach(bitcode -> this.huffmanBitCodesBySymbol.put(bitcode.getSymbol(), (HuffmanBitCode<T>)bitcode));
        int[] sortedBitCodes = new int[nSymbols];
        this.symbolsSortedByBitCode = new ArrayList<T>(nSymbols);
        this.bitLensSortedByBitCode = new int[nSymbols];
        int maxBitCode = 0;
        for (i2 = 0; i2 < nSymbols; ++i2) {
            HuffmanBitCode<T> huffmanCode = this.huffmanBitCodesByBitLengthThenCode.get(i2);
            sortedBitCodes[i2] = huffmanCode.getCodeWord();
            this.symbolsSortedByBitCode.add(huffmanCode.getSymbol());
            this.bitLensSortedByBitCode[i2] = huffmanCode.getCodeWordBitLength();
            maxBitCode = Integer.max(maxBitCode, huffmanCode.getCodeWord());
        }
        this.bitCodeToSymbol = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToSymbol, -1);
        for (i2 = 0; i2 < nSymbols; ++i2) {
            this.bitCodeToSymbol[this.huffmanBitCodesByBitLengthThenCode.get((int)i2).getCodeWord()] = i2;
        }
    }

    public List<HuffmanBitCode<T>> getCanonicalCodeWords() {
        TreeMap<Integer, SortedSet> symbolsByCodeLength = new TreeMap<Integer, SortedSet>();
        for (int i2 = 0; i2 < this.huffmanParams.getCodeWordLengths().size(); ++i2) {
            symbolsByCodeLength.computeIfAbsent(this.huffmanParams.getCodeWordLengths().get(i2), k -> new TreeSet()).add(this.huffmanParams.getSymbols().get(i2));
        }
        ArrayList<HuffmanBitCode<T>> canonicalCodes = new ArrayList<HuffmanBitCode<T>>(this.huffmanParams.getCodeWordLengths().size());
        int codeLength = 0;
        int codeValue = -1;
        for (Map.Entry symbolsForLength : symbolsByCodeLength.entrySet()) {
            for (Object symbol : (SortedSet)symbolsForLength.getValue()) {
                int bitLength = (Integer)symbolsForLength.getKey();
                ++codeValue;
                int delta = bitLength - codeLength;
                if (delta != 0) {
                    codeValue <<= delta;
                    codeLength += delta;
                }
                if (Integer.bitCount(codeValue) > bitLength) {
                    throw new IllegalArgumentException(String.format("Bit length (%d) for symbol (%d) out of range", Integer.bitCount(codeValue), symbol));
                }
                canonicalCodes.add(new HuffmanBitCode(symbol, codeValue, bitLength));
            }
        }
        canonicalCodes.sort(this.bitCodeComparator);
        return canonicalCodes;
    }

    public final long write(BitOutputStream bitOutputStream, T symbol) {
        HuffmanBitCode<T> code = this.huffmanBitCodesBySymbol.get(symbol);
        if (code == null) {
            throw new RuntimeException(String.format("Attempt to write a symbol (%d) that is not in the symbol alphabet for this huffman encoder (found code word %s).", symbol, code == null ? "null" : code.toString()));
        }
        bitOutputStream.write(code.getCodeWord(), code.getCodeWordBitLength());
        return code.getCodeWordBitLength();
    }

    public final T read(BitInputStream bitInputStream) {
        int previousCodeWordLength = 0;
        int codeWord = 0;
        for (int i2 = 0; i2 < this.huffmanBitCodesByBitLengthThenCode.size(); ++i2) {
            int newCodeWordLength = this.huffmanBitCodesByBitLengthThenCode.get(i2).getCodeWordBitLength();
            codeWord <<= newCodeWordLength - previousCodeWordLength;
            previousCodeWordLength = newCodeWordLength;
            int symbolIndex = this.bitCodeToSymbol[codeWord |= bitInputStream.readBits(newCodeWordLength - previousCodeWordLength)];
            if (symbolIndex > -1 && this.bitLensSortedByBitCode[symbolIndex] == newCodeWordLength) {
                return this.symbolsSortedByBitCode.get(symbolIndex);
            }
            for (int j = i2; this.huffmanBitCodesByBitLengthThenCode.get(j + 1).getCodeWordBitLength() == newCodeWordLength && j < this.huffmanBitCodesByBitLengthThenCode.size(); ++j) {
                ++i2;
            }
        }
        throw new RuntimeException("Unable to map huffman code from input stream to a valid symbol");
    }

    public int getCodeWordLenForValue(T value) {
        return this.huffmanBitCodesBySymbol.get(value).getCodeWordBitLength();
    }
}

