/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

public final class HuffmanBitCode<T> {
    private final T symbol;
    private final int codeWord;
    private final int codeWordBitLength;

    public HuffmanBitCode(T symbol, int codeWord, int codeWordBitLength) {
        this.symbol = symbol;
        this.codeWord = codeWord;
        this.codeWordBitLength = codeWordBitLength;
        if (codeWordBitLength > 31) {
            throw new IllegalArgumentException(String.format("Huffman codeword of length %d exceeds the maximum length of 31", codeWordBitLength));
        }
    }

    public T getSymbol() {
        return this.symbol;
    }

    public int getCodeWord() {
        return this.codeWord;
    }

    public int getCodeWordBitLength() {
        return this.codeWordBitLength;
    }

    public String toString() {
        return String.format("Symbol: %d CodeWord: %d (%s) BitLength: %d", this.symbol, this.codeWord, this.getBitCodeWithPrefix(), this.codeWordBitLength);
    }

    public String getBitCodeWithPrefix() {
        String codeWordBinaryString = Integer.toBinaryString(this.codeWord);
        StringBuffer binaryWordBuffer = new StringBuffer();
        for (int i2 = codeWordBinaryString.length(); i2 < this.codeWordBitLength; ++i2) {
            binaryWordBuffer.append('0');
        }
        binaryWordBuffer.append(codeWordBinaryString);
        return binaryWordBuffer.toString();
    }
}

