/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanParams;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class CanonicalHuffmanIntegerEncoding
extends CRAMEncoding<Integer> {
    private final HuffmanParams<Integer> huffmanParams;

    public CanonicalHuffmanIntegerEncoding(int[] symbols, int[] bitLengths) {
        super(EncodingID.HUFFMAN);
        this.huffmanParams = new HuffmanParams(Arrays.stream(symbols).boxed().collect(Collectors.toList()), Arrays.stream(bitLengths).boxed().collect(Collectors.toList()));
    }

    public static CanonicalHuffmanIntegerEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buf = ByteBuffer.wrap(serializedParams);
        int valueSize = ITF8.readUnsignedITF8(buf);
        int[] values = new int[valueSize];
        for (int i2 = 0; i2 < valueSize; ++i2) {
            values[i2] = ITF8.readUnsignedITF8(buf);
        }
        int lengthSize = ITF8.readUnsignedITF8(buf);
        int[] bitLengths = new int[lengthSize];
        for (int i3 = 0; i3 < lengthSize; ++i3) {
            bitLengths[i3] = ITF8.readUnsignedITF8(buf);
        }
        return new CanonicalHuffmanIntegerEncoding(values, bitLengths);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buf = ByteBuffer.allocate(5 * (this.huffmanParams.getSymbols().size() + this.huffmanParams.getCodeWordLengths().size()));
        ITF8.writeUnsignedITF8(this.huffmanParams.getSymbols().size(), buf);
        for (int value : this.huffmanParams.getSymbols()) {
            ITF8.writeUnsignedITF8(value, buf);
        }
        ITF8.writeUnsignedITF8(this.huffmanParams.getCodeWordLengths().size(), buf);
        for (int value : this.huffmanParams.getCodeWordLengths()) {
            ITF8.writeUnsignedITF8(value, buf);
        }
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new CanonicalHuffmanIntegerCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.huffmanParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalHuffmanIntegerEncoding that = (CanonicalHuffmanIntegerEncoding)o;
        return this.huffmanParams.equals(that.huffmanParams);
    }

    public int hashCode() {
        return this.huffmanParams.hashCode();
    }

    public String toString() {
        return this.huffmanParams.toString();
    }
}

