/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanByteCodec;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanParams;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;

public final class CanonicalHuffmanByteEncoding
extends CRAMEncoding<Byte> {
    private final HuffmanParams<Byte> huffmanParams;

    public CanonicalHuffmanByteEncoding(byte[] symbols, int[] bitLengths) {
        super(EncodingID.HUFFMAN);
        ArrayList<Byte> symbolList = new ArrayList<Byte>(symbols.length);
        for (byte b : symbols) {
            symbolList.add(b);
        }
        this.huffmanParams = new HuffmanParams(symbolList, Arrays.stream(bitLengths).boxed().collect(Collectors.toList()));
    }

    public static CanonicalHuffmanByteEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buf = ByteBuffer.wrap(serializedParams);
        int symbolListSize = ITF8.readUnsignedITF8(buf);
        byte[] symbols = new byte[symbolListSize];
        buf.get(symbols);
        int codeWordLengthsSize = ITF8.readUnsignedITF8(buf);
        int[] codeWordLengths = new int[codeWordLengthsSize];
        for (int i2 = 0; i2 < codeWordLengthsSize; ++i2) {
            codeWordLengths[i2] = ITF8.readUnsignedITF8(buf);
        }
        return new CanonicalHuffmanByteEncoding(symbols, codeWordLengths);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        int value;
        ByteBuffer buf = ByteBuffer.allocate(5 * (this.huffmanParams.getSymbols().size() + this.huffmanParams.getCodeWordLengths().size()));
        ITF8.writeUnsignedITF8(this.huffmanParams.getSymbols().size(), buf);
        Iterator<Number> iterator = this.huffmanParams.getSymbols().iterator();
        while (iterator.hasNext()) {
            value = iterator.next().byteValue();
            buf.put((byte)value);
        }
        ITF8.writeUnsignedITF8(this.huffmanParams.getCodeWordLengths().size(), buf);
        iterator = this.huffmanParams.getCodeWordLengths().iterator();
        while (iterator.hasNext()) {
            value = (Integer)iterator.next();
            ITF8.writeUnsignedITF8(value, buf);
        }
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Byte> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new CanonicalHuffmanByteCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.huffmanParams);
    }

    public String toString() {
        return this.huffmanParams.toString();
    }
}

