/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

final class Utils {
    Utils() {
    }

    private static void reverse(byte[] array, int offset, int size) {
        if (array == null) {
            return;
        }
        int i2 = offset;
        for (int j = offset + size - 1; j > i2; --j, ++i2) {
            byte tmp = array[j];
            array[j] = array[i2];
            array[i2] = tmp;
        }
    }

    static void reverse(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            Utils.reverse(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        } else {
            for (int i2 = 0; i2 < byteBuffer.limit(); ++i2) {
                byte tmp = byteBuffer.get(i2);
                byteBuffer.put(i2, byteBuffer.get(byteBuffer.limit() - i2 - 1));
                byteBuffer.put(byteBuffer.limit() - i2 - 1, tmp);
            }
        }
    }

    static int RANSDecodeGet(int r, int scaleBits) {
        return r & (1 << scaleBits) - 1;
    }

    static int RANSDecodeRenormalize(int r, ByteBuffer byteBuffer) {
        if (r < 0x800000) {
            while ((r = r << 8 | 0xFF & byteBuffer.get()) < 0x800000) {
            }
        }
        return r;
    }
}

