/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;

final class E04 {
    E04() {
    }

    static int compress(ByteBuffer inBuffer, RANSEncodingSymbol[] syms, ByteBuffer cp) {
        int in_size = inBuffer.remaining();
        ByteBuffer ptr = cp.slice();
        int rans0 = 0x800000;
        int rans1 = 0x800000;
        int rans2 = 0x800000;
        int rans3 = 0x800000;
        int i2 = in_size & 3;
        switch (i2) {
            case 3: {
                rans2 = syms[0xFF & inBuffer.get(in_size - (i2 - 2))].putSymbol(rans2, ptr);
            }
            case 2: {
                rans1 = syms[0xFF & inBuffer.get(in_size - (i2 - 1))].putSymbol(rans1, ptr);
            }
            case 1: {
                rans0 = syms[0xFF & inBuffer.get(in_size - i2)].putSymbol(rans0, ptr);
            }
        }
        for (i2 = in_size & 0xFFFFFFFC; i2 > 0; i2 -= 4) {
            int c3 = 0xFF & inBuffer.get(i2 - 1);
            int c2 = 0xFF & inBuffer.get(i2 - 2);
            int c1 = 0xFF & inBuffer.get(i2 - 3);
            int c0 = 0xFF & inBuffer.get(i2 - 4);
            rans3 = syms[c3].putSymbol(rans3, ptr);
            rans2 = syms[c2].putSymbol(rans2, ptr);
            rans1 = syms[c1].putSymbol(rans1, ptr);
            rans0 = syms[c0].putSymbol(rans0, ptr);
        }
        ptr.putInt(rans3);
        ptr.putInt(rans2);
        ptr.putInt(rans1);
        ptr.putInt(rans0);
        ptr.flip();
        int cdata_size = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        return cdata_size;
    }
}

