/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.ArithmeticDecoder;
import htsjdk.samtools.cram.compression.rans.RANSDecodingSymbol;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;

final class D04 {
    D04() {
    }

    static void uncompress(ByteBuffer inBuffer, ArithmeticDecoder D, RANSDecodingSymbol[] syms, ByteBuffer outBuffer) {
        int rans0 = inBuffer.getInt();
        int rans1 = inBuffer.getInt();
        int rans2 = inBuffer.getInt();
        int rans3 = inBuffer.getInt();
        int out_sz = outBuffer.remaining();
        int out_end = out_sz & 0xFFFFFFFC;
        for (int i2 = 0; i2 < out_end; i2 += 4) {
            byte c0 = D.R[Utils.RANSDecodeGet(rans0, 12)];
            byte c1 = D.R[Utils.RANSDecodeGet(rans1, 12)];
            byte c2 = D.R[Utils.RANSDecodeGet(rans2, 12)];
            byte c3 = D.R[Utils.RANSDecodeGet(rans3, 12)];
            outBuffer.put(i2, c0);
            outBuffer.put(i2 + 1, c1);
            outBuffer.put(i2 + 2, c2);
            outBuffer.put(i2 + 3, c3);
            rans0 = syms[0xFF & c0].advanceSymbolStep(rans0, 12);
            rans1 = syms[0xFF & c1].advanceSymbolStep(rans1, 12);
            rans2 = syms[0xFF & c2].advanceSymbolStep(rans2, 12);
            rans3 = syms[0xFF & c3].advanceSymbolStep(rans3, 12);
            rans0 = Utils.RANSDecodeRenormalize(rans0, inBuffer);
            rans1 = Utils.RANSDecodeRenormalize(rans1, inBuffer);
            rans2 = Utils.RANSDecodeRenormalize(rans2, inBuffer);
            rans3 = Utils.RANSDecodeRenormalize(rans3, inBuffer);
        }
        outBuffer.position(out_end);
        switch (out_sz & 3) {
            case 0: {
                break;
            }
            case 1: {
                byte c = D.R[Utils.RANSDecodeGet(rans0, 12)];
                syms[0xFF & c].advanceSymbol(rans0, inBuffer, 12);
                outBuffer.put(c);
                break;
            }
            case 2: {
                byte c = D.R[Utils.RANSDecodeGet(rans0, 12)];
                syms[0xFF & c].advanceSymbol(rans0, inBuffer, 12);
                outBuffer.put(c);
                c = D.R[Utils.RANSDecodeGet(rans1, 12)];
                syms[0xFF & c].advanceSymbol(rans1, inBuffer, 12);
                outBuffer.put(c);
                break;
            }
            case 3: {
                byte c = D.R[Utils.RANSDecodeGet(rans0, 12)];
                syms[0xFF & c].advanceSymbol(rans0, inBuffer, 12);
                outBuffer.put(c);
                c = D.R[Utils.RANSDecodeGet(rans1, 12)];
                syms[0xFF & c].advanceSymbol(rans1, inBuffer, 12);
                outBuffer.put(c);
                c = D.R[Utils.RANSDecodeGet(rans2, 12)];
                syms[0xFF & c].advanceSymbol(rans2, inBuffer, 12);
                outBuffer.put(c);
            }
        }
        outBuffer.position(0);
    }
}

