/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.build.CramContainerIterator;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public final class CramSpanContainerIterator
extends CramContainerIterator {
    private final SeekableStream seekableStream;
    private Iterator<Boundary> containerBoundaries;
    private Boundary currentBoundary;

    private CramSpanContainerIterator(SeekableStream seekableStream, long[] coordinates) throws IOException {
        super(seekableStream);
        this.seekableStream = seekableStream;
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
            boundaries.add(new Boundary(coordinates[i2], coordinates[i2 + 1]));
        }
        this.containerBoundaries = boundaries.iterator();
        this.currentBoundary = this.containerBoundaries.next();
    }

    public static CramSpanContainerIterator fromFileSpan(SeekableStream seekableStream, long[] coordinates) {
        try {
            seekableStream.seek(0L);
            return new CramSpanContainerIterator(seekableStream, coordinates);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentBoundary.hasNext()) {
            return true;
        }
        if (!this.containerBoundaries.hasNext()) {
            return false;
        }
        this.currentBoundary = this.containerBoundaries.next();
        return this.currentBoundary.hasNext();
    }

    @Override
    public Container next() {
        return this.currentBoundary.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not allowed.");
    }

    private class Boundary
    implements Iterator<Container> {
        final long start;
        final long end;

        public Boundary(long start, long end) {
            this.start = start;
            this.end = end;
            if (start >= end) {
                throw new RuntimeException("Boundary start is greater than end.");
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return CramSpanContainerIterator.this.seekableStream.position() <= this.end >> 16;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public Container next() {
            try {
                if (CramSpanContainerIterator.this.seekableStream.position() < this.start >> 16) {
                    CramSpanContainerIterator.this.seekableStream.seek(this.start >> 16);
                }
                if (!this.hasNext()) {
                    throw new RuntimeException("No more containers in this boundary.");
                }
                return new Container(CramSpanContainerIterator.this.getCramHeader().getCRAMVersion(), CramSpanContainerIterator.this.seekableStream, CramSpanContainerIterator.this.seekableStream.position());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

