/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CompressionHeaderEncodingMap;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.utils.ValidationUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CompressionHeaderFactory {
    public static final int BYTE_SPACE_SIZE = 256;
    public static final int ALL_BYTES_USED = -1;
    private static final int[] SINGLE_ZERO = new int[]{0};
    private final CRAMEncodingStrategy encodingStrategy;
    private final CompressionHeaderEncodingMap encodingMap;
    private final Map<Integer, EncodingDetails> bestTagEncodings = new HashMap<Integer, EncodingDetails>();
    private final ByteArrayOutputStream baosForTagValues = new ByteArrayOutputStream(0x100000);

    public CompressionHeaderFactory(CRAMEncodingStrategy encodingStrategy) {
        ValidationUtils.nonNull(encodingStrategy, "A CRAMEncodingStrategy is required");
        this.encodingMap = encodingStrategy.getCustomCompressionHeaderEncodingMap() == null ? new CompressionHeaderEncodingMap(encodingStrategy) : encodingStrategy.getCustomCompressionHeaderEncodingMap();
        this.encodingStrategy = encodingStrategy;
    }

    public CompressionHeader createCompressionHeader(List<CRAMCompressionRecord> containerCRAMCompressionRecords, boolean coordinateSorted) {
        CompressionHeader compressionHeader = new CompressionHeader(this.encodingMap, coordinateSorted, true, true);
        compressionHeader.setTagIdDictionary(CompressionHeaderFactory.buildTagIdDictionary(containerCRAMCompressionRecords));
        this.buildTagEncodings(containerCRAMCompressionRecords, compressionHeader);
        SubstitutionMatrix substitutionMatrix = new SubstitutionMatrix(containerCRAMCompressionRecords);
        CompressionHeaderFactory.updateSubstitutionCodes(containerCRAMCompressionRecords, substitutionMatrix);
        compressionHeader.setSubstitutionMatrix(substitutionMatrix);
        this.bestTagEncodings.clear();
        return compressionHeader;
    }

    public CRAMEncodingStrategy getEncodingStrategy() {
        return this.encodingStrategy;
    }

    private void buildTagEncodings(List<CRAMCompressionRecord> cramCompressionRecords, CompressionHeader compressionHeader) {
        HashSet<Integer> tagIdSet = new HashSet<Integer>();
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getTags() == null || record.getTags().size() == 0) continue;
            for (ReadTag tag : record.getTags()) {
                tagIdSet.add(tag.keyType3BytesAsInt);
            }
        }
        Iterator<CRAMCompressionRecord> iterator = tagIdSet.iterator();
        while (iterator.hasNext()) {
            int tagId = (Integer)((Object)iterator.next());
            if (this.bestTagEncodings.containsKey(tagId)) {
                compressionHeader.addTagEncoding(tagId, this.bestTagEncodings.get((Object)Integer.valueOf((int)tagId)).compressor, this.bestTagEncodings.get((Object)Integer.valueOf((int)tagId)).params);
                continue;
            }
            EncodingDetails e = this.buildEncodingForTag(cramCompressionRecords, tagId);
            compressionHeader.addTagEncoding(tagId, e.compressor, e.params);
            this.bestTagEncodings.put(tagId, e);
        }
    }

    static void updateSubstitutionCodes(List<CRAMCompressionRecord> cramCompressionRecords, SubstitutionMatrix substitutionMatrix) {
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getReadFeatures() == null) continue;
            for (ReadFeature recordFeature : record.getReadFeatures()) {
                Substitution substitution;
                if (recordFeature.getOperator() != 88 || (substitution = (Substitution)recordFeature).getCode() != -1) continue;
                byte refBase = substitution.getReferenceBase();
                byte base = substitution.getBase();
                substitution.setCode(substitutionMatrix.code(refBase, base));
            }
        }
    }

    private static byte[][][] buildTagIdDictionary(List<CRAMCompressionRecord> cramCompressionRecords) {
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag o1, ReadTag o2) {
                return o1.keyType3BytesAsInt - o2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> baComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length - o2.length != 0) {
                    return o1.length - o2.length;
                }
                for (int i2 = 0; i2 < o1.length; ++i2) {
                    if (o1[i2] == o2[i2]) continue;
                    return o1[i2] - o2[i2];
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> map = new TreeMap<byte[], MutableInt>(baComparator);
        MutableInt noTagCounter = new MutableInt();
        map.put(new byte[0], noTagCounter);
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getTags() == null) {
                ++noTagCounter.value;
                record.setTagIdsIndex(noTagCounter);
                continue;
            }
            record.getTags().sort(comparator);
            byte[] tagIds = new byte[record.getTags().size() * 3];
            int tagIndex = 0;
            for (int i2 = 0; i2 < record.getTags().size(); ++i2) {
                tagIds[i2 * 3] = (byte)record.getTags().get((int)tagIndex).keyType3Bytes.charAt(0);
                tagIds[i2 * 3 + 1] = (byte)record.getTags().get((int)tagIndex).keyType3Bytes.charAt(1);
                tagIds[i2 * 3 + 2] = (byte)record.getTags().get((int)tagIndex).keyType3Bytes.charAt(2);
                ++tagIndex;
            }
            MutableInt count = (MutableInt)map.get(tagIds);
            if (count == null) {
                count = new MutableInt();
                map.put(tagIds, count);
            }
            ++count.value;
            record.setTagIdsIndex(count);
        }
        byte[][][] dictionary = new byte[map.size()][][];
        int i3 = 0;
        for (byte[] idsAsBytes : map.keySet()) {
            int nofIds = idsAsBytes.length / 3;
            dictionary[i3] = new byte[nofIds][];
            int j = 0;
            while (j < idsAsBytes.length) {
                int idIndex = j / 3;
                dictionary[i3][idIndex] = new byte[3];
                dictionary[i3][idIndex][0] = idsAsBytes[j++];
                dictionary[i3][idIndex][1] = idsAsBytes[j++];
                dictionary[i3][idIndex][2] = idsAsBytes[j++];
            }
            ((MutableInt)map.get((Object)idsAsBytes)).value = i3++;
        }
        return dictionary;
    }

    static byte getTagType(int tagID) {
        return (byte)(tagID & 0xFF);
    }

    public ExternalCompressor getBestExternalCompressor(byte[] data) {
        return this.encodingMap.getBestExternalCompressor(data, this.encodingStrategy);
    }

    byte[] getDataForTag(List<CRAMCompressionRecord> cramCompressionRecords, int tagID) {
        this.baosForTagValues.reset();
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getTags() == null) continue;
            for (ReadTag tag : record.getTags()) {
                if (tag.keyType3BytesAsInt != tagID) continue;
                byte[] valueBytes = tag.getValueAsByteArray();
                try {
                    this.baosForTagValues.write(valueBytes);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
        return this.baosForTagValues.toByteArray();
    }

    public static ByteSizeRange getByteSizeRangeOfTagValues(List<CRAMCompressionRecord> records, int tagID) {
        byte type = CompressionHeaderFactory.getTagType(tagID);
        ByteSizeRange stats = new ByteSizeRange();
        for (CRAMCompressionRecord record : records) {
            if (record.getTags() == null) continue;
            for (ReadTag tag : record.getTags()) {
                if (tag.keyType3BytesAsInt != tagID) continue;
                int size = CompressionHeaderFactory.getTagValueByteSize(type, tag.getValue());
                if (stats.min > size) {
                    stats.min = size;
                }
                if (stats.max >= size) continue;
                stats.max = size;
            }
        }
        return stats;
    }

    static int getUnusedByte(byte[] array) {
        byte[] usage = new byte[256];
        for (byte b : array) {
            usage[0xFF & b] = 1;
        }
        for (int i2 = 0; i2 < usage.length; ++i2) {
            if (usage[i2] != 0) continue;
            return i2;
        }
        return -1;
    }

    private EncodingDescriptor buildTagEncodingForSize(int tagValueSize, int tagID) {
        return new ByteArrayLenEncoding(new CanonicalHuffmanIntegerEncoding(new int[]{tagValueSize}, SINGLE_ZERO), new ExternalByteArrayEncoding(tagID)).toEncodingDescriptor();
    }

    private EncodingDetails buildEncodingForTag(List<CRAMCompressionRecord> records, int tagID) {
        EncodingDetails details = new EncodingDetails();
        byte[] data = this.getDataForTag(records, tagID);
        details.compressor = this.getBestExternalCompressor(data);
        byte type = CompressionHeaderFactory.getTagType(tagID);
        switch (type) {
            case 65: 
            case 67: 
            case 99: {
                details.params = this.buildTagEncodingForSize(1, tagID);
                return details;
            }
            case 73: 
            case 102: 
            case 105: {
                details.params = this.buildTagEncodingForSize(4, tagID);
                return details;
            }
            case 83: 
            case 115: {
                details.params = this.buildTagEncodingForSize(2, tagID);
                return details;
            }
            case 66: 
            case 90: {
                int unusedByte;
                boolean singleSize;
                ByteSizeRange stats = CompressionHeaderFactory.getByteSizeRangeOfTagValues(records, tagID);
                boolean bl = singleSize = stats.min == stats.max;
                if (singleSize) {
                    details.params = this.buildTagEncodingForSize(stats.min, tagID);
                    return details;
                }
                if (type == 90) {
                    details.params = new ByteArrayStopEncoding(9, tagID).toEncodingDescriptor();
                    return details;
                }
                int minSize_threshold_ForByteArrayStopEncoding = 100;
                if (stats.min > 100 && (unusedByte = CompressionHeaderFactory.getUnusedByte(data)) > -1) {
                    details.params = new ByteArrayStopEncoding((byte)unusedByte, tagID).toEncodingDescriptor();
                    return details;
                }
                details.params = new ByteArrayLenEncoding(new ExternalIntegerEncoding(tagID), new ExternalByteArrayEncoding(tagID)).toEncodingDescriptor();
                return details;
            }
        }
        throw new IllegalArgumentException("Unknown tag type: " + (char)type);
    }

    static int getTagValueByteSize(byte type, Object value) {
        switch (type) {
            case 65: {
                return 1;
            }
            case 73: {
                return 4;
            }
            case 105: {
                return 4;
            }
            case 115: {
                return 2;
            }
            case 83: {
                return 2;
            }
            case 99: {
                return 1;
            }
            case 67: {
                return 1;
            }
            case 102: {
                return 4;
            }
            case 90: {
                return ((String)value).length() + 1;
            }
            case 66: {
                if (value instanceof byte[]) {
                    return 5 + ((byte[])value).length;
                }
                if (value instanceof short[]) {
                    return 5 + ((short[])value).length * 2;
                }
                if (value instanceof int[]) {
                    return 5 + ((int[])value).length * 4;
                }
                if (value instanceof float[]) {
                    return 5 + ((float[])value).length * 4;
                }
                if (value instanceof long[]) {
                    return 5 + ((long[])value).length * 4;
                }
                throw new RuntimeException("Unknown tag array class: " + value.getClass());
            }
        }
        throw new RuntimeException("Unknown tag type: " + (char)type);
    }

    private static class EncodingDetails {
        ExternalCompressor compressor;
        EncodingDescriptor params;

        private EncodingDetails() {
        }
    }

    static class ByteSizeRange {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        ByteSizeRange() {
        }
    }
}

