/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.util.StringUtil;

public class TextCigarCodec {
    private static final byte ZERO_BYTE = "0".getBytes()[0];
    private static final byte NINE_BYTE = "9".getBytes()[0];

    public static String encode(Cigar cigar) {
        if (cigar.isEmpty()) {
            return "*";
        }
        StringBuilder ret = new StringBuilder();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            ret.append(cigarElement.getLength());
            ret.append((Object)cigarElement.getOperator());
        }
        return ret.toString();
    }

    public static Cigar decode(String textCigar) {
        if ("*".equals(textCigar)) {
            return new Cigar();
        }
        Cigar ret = new Cigar();
        byte[] cigarBytes = StringUtil.stringToBytes(textCigar);
        for (int i2 = 0; i2 < cigarBytes.length; ++i2) {
            if (!TextCigarCodec.isDigit(cigarBytes[i2])) {
                throw new IllegalArgumentException("Malformed CIGAR string: " + textCigar);
            }
            int length = cigarBytes[i2] - ZERO_BYTE;
            ++i2;
            while (TextCigarCodec.isDigit(cigarBytes[i2])) {
                length = length * 10 + cigarBytes[i2] - ZERO_BYTE;
                ++i2;
            }
            CigarOperator operator = CigarOperator.characterToEnum(cigarBytes[i2]);
            ret.add(new CigarElement(length, operator));
        }
        return ret;
    }

    private static boolean isDigit(byte c) {
        return c >= ZERO_BYTE && c <= NINE_BYTE;
    }
}

