/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.Log;
import java.io.OutputStream;

public final class SBIIndexMerger
extends IndexMerger<SBIIndex> {
    private static final Log log = Log.getInstance(SBIIndexMerger.class);
    private SBIIndexWriter indexWriter;
    private long granularity = -1L;
    private long offset;
    private long recordCount;
    private long finalVirtualOffset;

    public SBIIndexMerger(OutputStream out, long headerLength) {
        super(out, headerLength);
        this.indexWriter = new SBIIndexWriter(out);
        this.offset = headerLength;
    }

    @Override
    public void processIndex(SBIIndex index, long partLength) {
        long[] virtualOffsets = index.getVirtualOffsets();
        for (int i2 = 0; i2 < virtualOffsets.length - 1; ++i2) {
            this.indexWriter.writeVirtualOffset(BlockCompressedFilePointerUtil.shift(virtualOffsets[i2], this.offset));
        }
        this.finalVirtualOffset = BlockCompressedFilePointerUtil.shift(virtualOffsets[virtualOffsets.length - 1], this.offset);
        SBIIndex.Header header = index.getHeader();
        this.offset += header.getFileLength();
        this.recordCount += header.getTotalNumberOfRecords();
        if (this.granularity == -1L) {
            this.granularity = header.getGranularity();
        } else if (this.granularity > 0L && this.granularity != header.getGranularity()) {
            log.warn("Different granularities so setting to 0 (unspecified)");
            this.granularity = 0L;
        }
    }

    @Override
    public void finish(long dataFileLength) {
        SBIIndex.Header header = new SBIIndex.Header(dataFileLength, SBIIndexWriter.EMPTY_MD5, SBIIndexWriter.EMPTY_UUID, this.recordCount, this.granularity);
        this.indexWriter.finish(header, this.finalVirtualOffset);
    }
}

