/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SAMFileHeader
extends AbstractSAMHeaderRecord {
    public static final String VERSION_TAG = "VN";
    public static final String SORT_ORDER_TAG = "SO";
    public static final String GROUP_ORDER_TAG = "GO";
    public static final String CURRENT_VERSION = "1.6";
    public static final Set<String> ACCEPTABLE_VERSIONS = CollectionUtil.makeSet("1.0", "1.3", "1.4", "1.5", "1.6");
    private SortOrder sortOrder = null;
    private GroupOrder groupOrder = null;
    private static final Log log = Log.getInstance(SAMFileHeader.class);
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("VN", "SO", "GO"));
    private List<SAMReadGroupRecord> mReadGroups = new ArrayList<SAMReadGroupRecord>();
    private List<SAMProgramRecord> mProgramRecords = new ArrayList<SAMProgramRecord>();
    private final Map<String, SAMReadGroupRecord> mReadGroupMap = new HashMap<String, SAMReadGroupRecord>();
    private final Map<String, SAMProgramRecord> mProgramRecordMap = new HashMap<String, SAMProgramRecord>();
    private SAMSequenceDictionary mSequenceDictionary = new SAMSequenceDictionary();
    private final List<String> mComments = new ArrayList<String>();
    private final List<SAMValidationError> mValidationErrors = new ArrayList<SAMValidationError>();

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public SAMFileHeader() {
        this.setAttribute(VERSION_TAG, CURRENT_VERSION);
    }

    public SAMFileHeader(SAMSequenceDictionary dict) {
        this();
        this.setSequenceDictionary(dict);
    }

    public String getVersion() {
        return this.getAttribute(VERSION_TAG);
    }

    public String getCreator() {
        return this.getAttribute("CR");
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.mSequenceDictionary;
    }

    public List<SAMReadGroupRecord> getReadGroups() {
        return Collections.unmodifiableList(this.mReadGroups);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceDictionary == null ? null : this.mSequenceDictionary.getSequence(name);
    }

    public SAMReadGroupRecord getReadGroup(String name) {
        return this.mReadGroupMap.get(name);
    }

    public void setSequenceDictionary(SAMSequenceDictionary sequenceDictionary) {
        this.mSequenceDictionary = sequenceDictionary;
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        this.mSequenceDictionary.addSequence(sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        return this.mSequenceDictionary.getSequence(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        return this.mSequenceDictionary.getSequenceIndex(sequenceName);
    }

    public void setReadGroups(List<SAMReadGroupRecord> readGroups) {
        this.mReadGroups = readGroups;
        this.mReadGroupMap.clear();
        for (SAMReadGroupRecord readGroupRecord : readGroups) {
            this.mReadGroupMap.put(readGroupRecord.getReadGroupId(), readGroupRecord);
        }
    }

    public void addReadGroup(SAMReadGroupRecord readGroup) {
        if (this.mReadGroupMap.containsKey(readGroup.getReadGroupId())) {
            throw new IllegalArgumentException("Read group with group id " + readGroup.getReadGroupId() + " already exists in SAMFileHeader!");
        }
        this.mReadGroups.add(readGroup);
        this.mReadGroupMap.put(readGroup.getReadGroupId(), readGroup);
    }

    public List<SAMProgramRecord> getProgramRecords() {
        return Collections.unmodifiableList(this.mProgramRecords);
    }

    public void addProgramRecord(SAMProgramRecord programRecord) {
        if (this.mProgramRecordMap.containsKey(programRecord.getProgramGroupId())) {
            throw new IllegalArgumentException("Program record with group id " + programRecord.getProgramGroupId() + " already exists in SAMFileHeader!");
        }
        this.mProgramRecords.add(programRecord);
        this.mProgramRecordMap.put(programRecord.getProgramGroupId(), programRecord);
    }

    public SAMProgramRecord getProgramRecord(String pgId) {
        return this.mProgramRecordMap.get(pgId);
    }

    public void setProgramRecords(List<SAMProgramRecord> programRecords) {
        this.mProgramRecords = programRecords;
        this.mProgramRecordMap.clear();
        for (SAMProgramRecord programRecord : this.mProgramRecords) {
            this.mProgramRecordMap.put(programRecord.getProgramGroupId(), programRecord);
        }
    }

    public SAMProgramRecord createProgramRecord() {
        for (int i2 = 0; i2 < Integer.MAX_VALUE; ++i2) {
            String s = Integer.toString(i2);
            if (this.mProgramRecordMap.containsKey(s)) continue;
            SAMProgramRecord ret = new SAMProgramRecord(s);
            this.addProgramRecord(ret);
            return ret;
        }
        throw new IllegalStateException("Surprising number of SAMProgramRecords");
    }

    public SortOrder getSortOrder() {
        if (this.sortOrder == null) {
            String so = this.getAttribute(SORT_ORDER_TAG);
            if (so == null) {
                this.sortOrder = SortOrder.unsorted;
            } else {
                try {
                    return SortOrder.valueOf(so);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Found non-conforming header SO tag: " + so + ". Treating as 'unknown'.");
                    this.sortOrder = SortOrder.unknown;
                }
            }
        }
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder so) {
        this.sortOrder = so;
        super.setAttribute(SORT_ORDER_TAG, so.name());
    }

    public GroupOrder getGroupOrder() {
        if (this.groupOrder == null) {
            String go = this.getAttribute(GROUP_ORDER_TAG);
            if (go == null) {
                this.groupOrder = GroupOrder.none;
            } else {
                try {
                    return GroupOrder.valueOf(go);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Found non conforming header GO tag: " + go + ". Treating as 'none'.");
                    this.groupOrder = GroupOrder.none;
                }
            }
        }
        return this.groupOrder;
    }

    public void setGroupOrder(GroupOrder go) {
        this.groupOrder = go;
        super.setAttribute(GROUP_ORDER_TAG, go.name());
    }

    @Override
    @Deprecated
    public void setAttribute(String key, Object value) {
        if (key.equals(SORT_ORDER_TAG) || key.equals(GROUP_ORDER_TAG)) {
            this.setAttribute(key, value.toString());
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public void setAttribute(String key, String value) {
        String tempVal = value;
        if (key.equals(SORT_ORDER_TAG)) {
            this.sortOrder = null;
            try {
                tempVal = SortOrder.valueOf(value).toString();
            }
            catch (IllegalArgumentException e) {
                tempVal = SortOrder.unknown.toString();
            }
        } else if (key.equals(GROUP_ORDER_TAG)) {
            this.groupOrder = null;
        }
        super.setAttribute(key, tempVal);
    }

    @Deprecated
    public String getTextHeader() {
        return null;
    }

    @Deprecated
    public void setTextHeader(String textHeader) {
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.mComments);
    }

    public void addComment(String comment) {
        if (!comment.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX)) {
            comment = SAMTextHeaderCodec.COMMENT_PREFIX + comment;
        }
        this.mComments.add(comment);
    }

    public void setComments(Collection<String> comments) {
        this.mComments.clear();
        for (String comment : comments) {
            this.addComment(comment);
        }
    }

    public List<SAMValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this.mValidationErrors);
    }

    public void addValidationError(SAMValidationError error) {
        this.mValidationErrors.add(error);
    }

    public void setValidationErrors(Collection<SAMValidationError> errors) {
        this.mValidationErrors.clear();
        this.mValidationErrors.addAll(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMFileHeader that = (SAMFileHeader)o;
        if (!this.attributesEqual(that)) {
            return false;
        }
        if (this.mProgramRecords != null ? !this.mProgramRecords.equals(that.mProgramRecords) : that.mProgramRecords != null) {
            return false;
        }
        if (this.mReadGroups != null ? !this.mReadGroups.equals(that.mReadGroups) : that.mReadGroups != null) {
            return false;
        }
        return !(this.mSequenceDictionary != null ? !this.mSequenceDictionary.equals(that.mSequenceDictionary) : that.mSequenceDictionary != null);
    }

    public int hashCode() {
        int result = this.attributesHashCode();
        result = 31 * result + (this.mSequenceDictionary != null ? this.mSequenceDictionary.hashCode() : 0);
        result = 31 * result + (this.mReadGroups != null ? this.mReadGroups.hashCode() : 0);
        result = 31 * result + (this.mProgramRecords != null ? this.mProgramRecords.hashCode() : 0);
        return result;
    }

    public final SAMFileHeader clone() {
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        codec.setValidationStringency(ValidationStringency.SILENT);
        return codec.decode(BufferedLineReader.fromString(this.getSAMString()), "SAMFileHeader.clone");
    }

    @Override
    public String getSAMString() {
        StringWriter stringWriter = new StringWriter();
        new SAMTextHeaderCodec().encode(stringWriter, this);
        return stringWriter.toString();
    }

    public static class PgIdGenerator {
        private int recordCounter;
        private final Set<String> idsThatAreAlreadyTaken = new HashSet<String>();

        public PgIdGenerator(SAMFileHeader header) {
            for (SAMProgramRecord pgRecord : header.getProgramRecords()) {
                this.idsThatAreAlreadyTaken.add(pgRecord.getProgramGroupId());
            }
            this.recordCounter = this.idsThatAreAlreadyTaken.size();
        }

        public String getNonCollidingId(String recordId) {
            String newId;
            if (!this.idsThatAreAlreadyTaken.contains(recordId)) {
                this.idsThatAreAlreadyTaken.add(recordId);
                ++this.recordCounter;
                return recordId;
            }
            while (this.idsThatAreAlreadyTaken.contains(newId = recordId + "." + SamFileHeaderMerger.positiveFourDigitBase36Str(this.recordCounter++))) {
            }
            this.idsThatAreAlreadyTaken.add(newId);
            return newId;
        }
    }

    public static enum GroupOrder {
        none,
        query,
        reference;

    }

    public static enum SortOrder {
        unsorted(() -> null),
        queryname(SAMRecordQueryNameComparator::new),
        coordinate(SAMRecordCoordinateComparator::new),
        duplicate(SAMRecordDuplicateComparator::new),
        unknown(() -> null);

        private final Supplier<SAMRecordComparator> comparatorSupplier;

        private SortOrder(Supplier<SAMRecordComparator> comparatorClass) {
            this.comparatorSupplier = comparatorClass;
        }

        @Deprecated
        public Class<? extends SAMRecordComparator> getComparator() {
            return this.comparatorSupplier.get().getClass();
        }

        public SAMRecordComparator getComparatorInstance() {
            return this.comparatorSupplier.get();
        }
    }
}

