/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

class HighAccuracyDownsamplingIterator
extends DownsamplingIterator {
    private final Iterator<SAMRecord> underlyingIterator;
    private final Random random;
    private SAMRecord nextRecord;
    private final Map<String, Boolean> decisions = new HashMap<String, Boolean>();
    private double targetAccuracy = 1.0E-4;
    private long totalTemplates;
    private long keptTemplates;
    private Iterator<SAMRecord> bufferedRecords = new ArrayList().iterator();
    private Set<String> bufferedRecordsToKeep;

    @Override
    public boolean isHigherAccuracy() {
        return true;
    }

    HighAccuracyDownsamplingIterator(Iterator<SAMRecord> iterator, double proportion, int seed) {
        super(proportion);
        this.underlyingIterator = iterator;
        this.random = new Random(seed);
    }

    public DownsamplingIterator setTargetAccuracy(double accuracy) {
        if (accuracy >= 1.0 || accuracy <= 4.656612875245797E-10) {
            throw new IllegalArgumentException("Illegal value. Must be 1/MAX_INT < accuracy < 1");
        }
        this.targetAccuracy = accuracy;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null || this.advance();
    }

    @Override
    public SAMRecord next() {
        if (this.nextRecord == null) {
            throw new NoSuchElementException("Call to next() when hasNext() == false");
        }
        SAMRecord retval = this.nextRecord;
        this.advance();
        return retval;
    }

    protected Iterator<SAMRecord> getUnderlyingIterator() {
        return this.underlyingIterator;
    }

    protected boolean advance() {
        this.nextRecord = null;
        while (this.nextRecord == null && (this.bufferedRecords.hasNext() || this.bufferNextChunkOfRecords(this.getTargetProportion(), this.targetAccuracy))) {
            boolean keepThisRecord;
            SAMRecord rec = this.bufferedRecords.next();
            String key = rec.getReadName();
            Boolean previous = this.decisions.get(key);
            if (previous == null) {
                keepThisRecord = this.bufferedRecordsToKeep.contains(rec.getReadName());
                this.decisions.put(key, keepThisRecord);
            } else {
                keepThisRecord = previous;
            }
            if (keepThisRecord) {
                this.nextRecord = rec;
                this.recordAcceptedRecord();
                continue;
            }
            this.recordDiscardedRecord();
        }
        return this.nextRecord != null;
    }

    protected boolean bufferNextChunkOfRecords(double proportion, double accuracy) {
        int templatesToRead = (int)Math.ceil(1.0 / accuracy);
        HashSet<String> names = new HashSet<String>();
        ArrayList<SAMRecord> recs = new ArrayList<SAMRecord>(templatesToRead);
        this.readFromUnderlyingIterator(recs, names, templatesToRead);
        int templatesRead = names.size();
        int templatesToKeep = this.calculateTemplatesToKeep(templatesRead, proportion);
        int templatesToDiscard = templatesRead - templatesToKeep;
        ArrayList<String> tmp = new ArrayList<String>(names);
        Collections.shuffle(tmp, this.random);
        for (int i2 = 0; i2 < templatesToDiscard; ++i2) {
            names.remove(tmp.get(i2));
        }
        this.bufferedRecordsToKeep = names;
        this.bufferedRecords = recs.iterator();
        this.totalTemplates += (long)templatesRead;
        this.keptTemplates += (long)names.size();
        return !recs.isEmpty();
    }

    protected int calculateTemplatesToKeep(int templatesRead, double proportion) {
        double rawTemplatesToKeep = (double)templatesRead * proportion;
        return (double)this.keptTemplates / (double)this.totalTemplates < proportion ? (int)Math.ceil(rawTemplatesToKeep) : (int)Math.floor(rawTemplatesToKeep);
    }

    protected void readFromUnderlyingIterator(List<SAMRecord> recs, Set<String> names, int templatesToRead) {
        while (this.underlyingIterator.hasNext() && names.size() < templatesToRead) {
            SAMRecord rec = this.underlyingIterator.next();
            recs.add(rec);
            if (this.decisions.containsKey(rec.getReadName())) continue;
            names.add(rec.getReadName());
        }
    }
}

