/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Comparator;

class ComparableSamRecordIterator
extends PeekableIterator<SAMRecord>
implements Comparable<ComparableSamRecordIterator> {
    private final Comparator<SAMRecord> comparator;
    private final SamReader reader;

    public ComparableSamRecordIterator(SamReader sam2, CloseableIterator<SAMRecord> iterator, Comparator<SAMRecord> comparator) {
        super(iterator);
        this.reader = sam2;
        this.comparator = comparator;
    }

    public SamReader getReader() {
        return this.reader;
    }

    @Override
    public int compareTo(ComparableSamRecordIterator that) {
        if (this.comparator.getClass() != that.comparator.getClass()) {
            throw new IllegalStateException("Attempt to compare two ComparableSAMRecordIterators that have different orderings internally");
        }
        SAMRecord record = (SAMRecord)this.peek();
        SAMRecord record2 = (SAMRecord)that.peek();
        return this.comparator.compare(record, record2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((ComparableSamRecordIterator)o) == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ComparableSamRecordIterator should not be hashed because it can change value");
    }
}

