/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CSIIndex;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamIndexes;
import htsjdk.samtools.SamReader;
import java.util.Arrays;
import java.util.List;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            if (SamIndexes.BAI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int indexCount = 0;
                for (int i2 = 0; i2 < numRefs; ++i2) {
                    BAMIndexContent content = existingIndex.getQueryResults(i2);
                    for (Chunk chunk : content.getAllChunks()) {
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(chunk));
                        ++chunkCount;
                        SAMRecord sam2 = null;
                        try {
                            sam2 = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Last good record " + sam2 + " in chunk " + chunk + " chunkCount=" + chunkCount, e);
                        }
                    }
                    LinearIndex linearIndex = content.getLinearIndex();
                    for (long l : linearIndex.getIndexEntries()) {
                        try {
                            if (l == 0L) continue;
                            SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                            SAMRecord sam3 = (SAMRecord)iter.next();
                            ++indexCount;
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                        }
                    }
                }
                return chunkCount;
            }
            if (SamIndexes.CSI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CSIIndex existingIndex = (CSIIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                for (int i3 = 0; i3 < numRefs; ++i3) {
                    BAMIndexContent content = existingIndex.getQueryResults(i3);
                    for (Chunk c : content.getAllChunks()) {
                        SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        ++chunkCount;
                        SAMRecord sam4 = null;
                        try {
                            sam4 = (SAMRecord)sAMRecordIterator.next();
                            sAMRecordIterator.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Last good record " + sam4 + " in chunk " + c + " chunkCount=" + chunkCount, e);
                        }
                    }
                }
                return chunkCount;
            }
        }
        return 0;
    }

    public static int lessExhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            if (SamIndexes.BAI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int indexCount = 0;
                for (int i2 = 0; i2 < numRefs; ++i2) {
                    BAMIndexContent content = existingIndex.getQueryResults(i2);
                    List<Chunk> chunks = content.getAllChunks();
                    int numChunks = chunks.size();
                    for (int chunkNo : Arrays.asList(0, numChunks - 1)) {
                        ++chunkCount;
                        Chunk c = chunks.get(chunkNo);
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        try {
                            SAMRecord sam2 = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception querying chunk " + chunkNo + " from reference index " + i2, e);
                        }
                    }
                    long[] linearIndexEntries = content.getLinearIndex().getIndexEntries();
                    for (int binNo : Arrays.asList(0, linearIndexEntries.length - 1)) {
                        ++indexCount;
                        long l = linearIndexEntries[binNo];
                        try {
                            if (l == 0L) continue;
                            SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                            SAMRecord sam3 = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                        }
                    }
                }
                return chunkCount;
            }
            if (SamIndexes.CSI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CSIIndex existingIndex = (CSIIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                for (int i3 = 0; i3 < numRefs; ++i3) {
                    BAMIndexContent content = existingIndex.getQueryResults(i3);
                    List<Chunk> chunks = content.getAllChunks();
                    int numChunks = chunks.size();
                    for (int chunkNo : Arrays.asList(0, numChunks - 1)) {
                        ++chunkCount;
                        Chunk c = chunks.get(chunkNo);
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        try {
                            SAMRecord sam4 = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception querying chunk " + chunkNo + " from reference index " + i3, e);
                        }
                    }
                }
                return chunkCount;
            }
        }
        return 0;
    }

    public static enum IndexValidationStringency {
        EXHAUSTIVE,
        LESS_EXHAUSTIVE,
        NONE;

    }
}

