/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Manager;
import gov.nih.nlm.ncbi.ngs.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ngs.ErrorMsg;
import ngs.Package;

class LibVersionChecker {
    LibVersionChecker() {
    }

    static Version getVersion(String string, String string2, boolean bl) {
        String string3;
        Vector<String> vector = new Vector<String>();
        String string4 = System.getProperty("java.home");
        if (string4 != null) {
            vector.add(string4 + LibPathIterator.fileSeparator() + "bin" + LibPathIterator.fileSeparator() + "java");
            if (!LibVersionChecker.tryJava(vector)) {
                vector.remove(0);
            }
        }
        if (vector.size() == 0) {
            vector.add("java");
            if (!LibVersionChecker.tryJava(vector)) {
                throw new RuntimeException("Failed to check library " + string2 + " version: failed to execute java");
            }
        }
        if ((string3 = System.getProperty("java.class.path")) != null) {
            vector.add("-cp");
            vector.add(string3);
        }
        vector.add(LibVersionChecker.createPropertyString("java.library.path"));
        if (System.getProperty("vdb.log") != null) {
            vector.add(LibVersionChecker.createPropertyString("vdb.log"));
        }
        vector.add("gov.nih.nlm.ncbi.ngs.LibVersionChecker");
        vector.add(string);
        vector.add(string2);
        if (bl) {
            vector.add("true");
        }
        Logger.finer(">>> RUNNING CHILD ...");
        String string5 = null;
        try {
            String[] stringArray = new String[vector.size()];
            for (int j = 0; j < vector.size(); ++j) {
                stringArray[j] = vector.elementAt(j);
            }
            Logger.finest(stringArray);
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string6 = null;
            while ((string6 = bufferedReader2.readLine()) != null) {
                System.err.println(string6);
            }
            bufferedReader2.close();
            while ((string6 = bufferedReader.readLine()) != null) {
                Pattern pattern = Pattern.compile("^LibManager: version='(.*)'$");
                Matcher matcher = pattern.matcher(string6);
                while (matcher.find() && (string5 = matcher.group(1)) == null) {
                }
                if (string5 != null) continue;
                System.out.println(string6);
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            Logger.finest(exception);
        }
        Logger.finer("<<< Done CHILD");
        if (string5 != null) {
            return new Version(string5);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        LibVersionChecker libVersionChecker = new LibVersionChecker();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RuntimeException("Not enough arguments: should be 2 or 3");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = stringArray.length == 3 && stringArray[2].equals("true");
        String string3 = libVersionChecker.checkLib(string, string2, bl);
        if (string3 != null) {
            System.out.println("LibManager: version='" + string3 + "'");
        }
    }

    private String checkLib(String string, String string2, boolean bl) {
        Logger.finest("> Checking the version of " + string2 + " library...");
        Logger.finest(">> Loading the library...");
        boolean bl2 = false;
        try {
            if (bl) {
                System.loadLibrary(string2);
            } else {
                System.load(string2);
            }
            bl2 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.finest("<< Failed to load library " + string2);
            Logger.finest(unsatisfiedLinkError);
        }
        String string3 = null;
        if (bl2) {
            Logger.finest(">> Checking current version of the library...");
            string3 = LibVersionChecker.getLoadedVersion(string);
            Logger.finest("<< The current version of " + string2 + " = " + string3);
        }
        Logger.finest("< Done checking version of the library");
        return string3;
    }

    static String getLoadedVersion(String string) {
        try {
            if (string.equals("ncbi-vdb")) {
                return Manager.getPackageVersion();
            }
            if (string.equals("ngs-sdk")) {
                return Package.getPackageVersion();
            }
            Logger.warning("It is not known how to check the version of " + string + " library");
            return null;
        }
        catch (ErrorMsg errorMsg) {
            Logger.finest(errorMsg);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.finest(unsatisfiedLinkError);
        }
        return null;
    }

    private static boolean tryJava(Vector<String> vector) {
        try {
            Process process = Runtime.getRuntime().exec(vector.elementAt(0) + " -?");
            if (process.waitFor() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String createPropertyString(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            throw new RuntimeException("Property " + string + " is not defined");
        }
        return "-D" + string + "=" + string2 + "";
    }
}

