/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibManager;
import gov.nih.nlm.ncbi.ngs.Logger;
import java.io.File;

class LibPathIterator {
    private static final String NCBI_NGS_JAR_NAME = "ngs-java.jar";
    private LibManager mgr;
    private LibManager.Location location;
    private LibManager.Location crnLocation;
    private int iLocation;
    private String[] paths;
    private int iPaths;
    private String separator;
    private String[] filenames;
    private int iFilename;
    private String abspath;
    private boolean parents;

    LibPathIterator(LibManager libManager, String[] stringArray) {
        this(libManager, null, stringArray, false);
    }

    LibPathIterator(LibManager libManager, String[] stringArray, boolean bl) {
        this(libManager, null, stringArray, bl);
    }

    LibPathIterator(LibManager.Location location, String[] stringArray) {
        this(null, location, stringArray, false);
    }

    LibPathIterator(LibManager libManager, LibManager.Location location, String[] stringArray, boolean bl) {
        Logger.finer("Creating LibPathIterator(" + this.toString(stringArray) + ", " + (Object)((Object)location) + ")...");
        if (libManager == null && location == null) {
            throw new NullPointerException();
        }
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.mgr = libManager;
        this.location = location;
        this.filenames = stringArray;
        this.parents = bl;
        this.separator = LibPathIterator.fileSeparator();
        this.reset();
    }

    String nextName() {
        String string;
        String string2;
        do {
            if (!(this.paths != null && this.iPaths < this.paths.length || this.reset())) {
                return null;
            }
            string2 = this.paths[this.iPaths];
            string = null;
            if (this.filenames != null) {
                string = this.filenames[this.iFilename];
            }
            if (this.filenames == null) {
                ++this.iPaths;
                continue;
            }
            if (++this.iFilename < this.filenames.length) continue;
            this.iFilename = 0;
            ++this.iPaths;
        } while (string2.length() == 0);
        LibManager.Location location = this.location;
        if (location == null) {
            location = this.crnLocation;
        }
        if (this.separator == null) {
            throw new NullPointerException();
        }
        string2 = string2 + this.separator + string;
        return string2;
    }

    static boolean list(String string) {
        return LibPathIterator.iterate(new LibManager(new String[0], new String[0]), string, false);
    }

    static boolean deleteLibraries(LibManager libManager, String string) {
        return LibPathIterator.iterate(libManager, string, true);
    }

    private boolean reset() {
        if (this.location != null) {
            if (this.crnLocation != null) {
                return false;
            }
            this.crnLocation = this.location;
        } else if (this.crnLocation == null) {
            this.iLocation = -1;
        }
        block8: while (true) {
            ++this.iLocation;
            Logger.finest("LibPathIterator.reset() " + this.iLocation);
            if (this.location == null) {
                if (this.iLocation >= this.mgr.locations().length) {
                    return false;
                }
                this.crnLocation = this.mgr.locations()[this.iLocation];
                Logger.finest("LibPathIterator.reset(" + (Object)((Object)this.crnLocation) + ")");
            } else if (this.iLocation > 1) {
                return false;
            }
            this.iPaths = 0;
            String string = LibPathIterator.pathSeparator();
            String string2 = null;
            switch (this.crnLocation) {
                case CLASSPATH: {
                    string2 = System.getProperty("java.class.path");
                    Logger.finest("java.class.path = " + string2);
                    if (!this.resetPaths(string2, string)) continue block8;
                    return true;
                }
                case CWD: {
                    if (!this.resetPaths(System.getProperty("user.dir"), string)) continue block8;
                    return true;
                }
                case LIBPATH: {
                    string2 = System.getProperty("java.library.path");
                    Logger.finest("java.library.path = " + string2);
                    if (!this.resetPaths(string2, string)) continue block8;
                    return true;
                }
                case NCBI_HOME: {
                    if (!this.resetPaths(this.ncbiLibHome())) continue block8;
                    return true;
                }
                case NCBI_NGS_JAR_DIR: {
                    string2 = this.findJarDir(string);
                    if (string2 == null) {
                        Logger.finest("ngs-java.jar was not found");
                        continue block8;
                    }
                    Logger.finest("jar directory is " + string2);
                    this.resetPaths(string2);
                    return true;
                }
                case TMP: {
                    string2 = this.findTmpDirEnv();
                    if (string2 != null) {
                        Logger.fine("Use " + string2 + " as temporary directory");
                        this.resetPaths(string2);
                        return true;
                    }
                    Logger.finest("Temporary directory was not found in environment");
                    if (this.resetPathsToTmpDirs()) {
                        Logger.finest("Found a temporary directory");
                        return true;
                    }
                    Logger.fine("Could not find any temporary directory");
                    continue block8;
                }
            }
        }
    }

    private String findJarDir(String string) {
        String string2 = System.getProperty("java.class.path");
        Logger.finest("java.class.path = " + string2);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(string);
        for (int j = 0; j < stringArray.length; ++j) {
            String string3;
            Logger.finest("findJarDir() " + j + " " + stringArray[j]);
            if (!stringArray[j].endsWith(NCBI_NGS_JAR_NAME)) continue;
            File file = new File(stringArray[j]);
            if (!file.exists()) {
                System.err.println("ngs-java.jar from class path does not exist");
                continue;
            }
            Logger.finest("Found NCBI jar file: " + stringArray[j]);
            String string4 = null;
            if (NCBI_NGS_JAR_NAME.equals(stringArray[j])) {
                string4 = System.getProperty("user.dir");
                if (string4 == null) {
                    System.err.println("cannot get directory for ngs-java.jar");
                    continue;
                }
            } else {
                string4 = stringArray[j].substring(0, stringArray[j].length() - NCBI_NGS_JAR_NAME.length());
            }
            if ((string3 = LibPathIterator.fileSeparator()) != null && string3.length() == 1 && string4.length() > 0 && string4.charAt(string4.length() - 1) == string3.charAt(0)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            return string4;
        }
        return null;
    }

    private String findTmpDirEnv() {
        String string = "TMPDIR";
        String string2 = System.getenv(string);
        if (string2 != null) {
            Logger.finest(string + " = " + string2);
            return string2;
        }
        string = "TEMP";
        string2 = System.getenv(string);
        if (string2 != null) {
            Logger.finest(string + " = " + string2);
            return string2;
        }
        string = "TMP";
        string2 = System.getenv(string);
        if (string2 != null) {
            Logger.finest(string + " = " + string2);
            return string2;
        }
        string = "TEMPDIR";
        string2 = System.getenv(string);
        if (string2 != null) {
            Logger.finest(string + " = " + string2);
            return string2;
        }
        return null;
    }

    private boolean resetPathsToTmpDirs() {
        int n = 0;
        String string = "/var/tmp";
        File file = new File(string);
        if (file.exists()) {
            ++n;
        } else {
            file = null;
        }
        String string2 = "/tmp";
        File file2 = new File(string2);
        if (file2.exists()) {
            ++n;
        } else {
            file2 = null;
        }
        if (n == 0) {
            return false;
        }
        if (this.paths == null || this.paths.length != n) {
            this.paths = new String[n];
        }
        int n2 = 0;
        if (file != null) {
            this.paths[n2++] = string;
        }
        if (file2 != null) {
            this.paths[n2++] = string2;
        }
        return true;
    }

    private boolean resetPaths(String string) {
        return this.resetPaths(string, null);
    }

    private boolean resetPaths(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 != null) {
            this.paths = string.split(string2);
            if (this.crnLocation == LibManager.Location.CLASSPATH) {
                for (int j = 0; j < this.paths.length; ++j) {
                    File file = new File(this.paths[j]);
                    if (!file.isFile()) continue;
                    String string3 = file.getParent();
                    if (string3 == null) {
                        string3 = System.getProperty("user.dir");
                    }
                    if (string3 == null) {
                        System.err.println("cannot get parent directory for " + this.paths[j]);
                        this.paths[j] = ".";
                        continue;
                    }
                    this.paths[j] = string3;
                }
            }
        } else {
            if (this.paths == null || this.paths.length != 1) {
                this.paths = new String[1];
            }
            this.paths[0] = string;
        }
        return true;
    }

    private boolean mkdir(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
                return false;
            }
            if (bl) {
                try {
                    file.setExecutable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
                try {
                    file.setReadable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
                try {
                    file.setWritable(false, false);
                }
                catch (SecurityException securityException) {
                    Logger.fine(securityException);
                }
            }
            try {
                file.setExecutable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
            try {
                file.setReadable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
            try {
                file.setWritable(true, true);
            }
            catch (SecurityException securityException) {
                Logger.fine(securityException);
            }
        }
        return true;
    }

    static String ncbiHome() {
        String string = System.getProperty("user.home");
        if (string == null) {
            return null;
        }
        return string + LibPathIterator.fileSeparator() + ".ncbi";
    }

    private String ncbiLibHome() {
        String string = LibPathIterator.ncbiHome();
        if (string == null) {
            return null;
        }
        if (this.parents && !this.mkdir(string, true)) {
            return null;
        }
        string = string + LibPathIterator.fileSeparator() + "lib";
        switch (LibManager.detectJVM()) {
            case b64: {
                string = string + "64";
                break;
            }
            case b32: {
                string = string + "32";
            }
        }
        if (this.parents && !this.mkdir(string, false)) {
            return null;
        }
        return string;
    }

    private static String pathSeparator() {
        String string;
        String string2 = System.getProperty("path.separator");
        if (string2 == null && (string = System.getProperty("os.name")) != null && string.indexOf("win") >= 0) {
            string2 = ";";
        }
        if (string2 == null) {
            string2 = ":";
        }
        return string2;
    }

    private String toString(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        String string = "[";
        for (int j = 0; j < stringArray.length; ++j) {
            if (j > 0) {
                string = string + ", ";
            }
            string = string + stringArray[j];
        }
        string = string + "]";
        return string;
    }

    static String fileSeparator() {
        String string;
        String string2 = System.getProperty("file.separator");
        if (string2 == null && (string = System.getProperty("os.name")) != null && string.indexOf("win") >= 0) {
            string2 = "\\";
        }
        if (string2 == null) {
            string2 = "/";
        }
        return string2;
    }

    private static boolean iterate(LibManager libManager, String string, boolean bl) {
        boolean bl2 = !bl;
        LibPathIterator libPathIterator = new LibPathIterator(libManager, LibManager.mapLibraryName(string));
        String string2 = null;
        int n = 0;
        while ((string2 = libPathIterator.nextName()) != null) {
            File file = new File(string2);
            boolean bl3 = file.exists();
            System.err.println("(" + ++n + ") " + string2 + " " + (bl3 ? "+" : "-"));
            if (!bl || !bl3) continue;
            try {
                bl3 = file.delete();
                if (bl3) {
                    bl2 = bl3;
                    continue;
                }
                System.err.println("Cannot delete '" + string2 + "'");
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot delete '" + string2 + "': " + securityException);
            }
        }
        return bl2;
    }
}

