/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.DownloadManager;
import gov.nih.nlm.ncbi.ngs.FileCreator;
import gov.nih.nlm.ncbi.ngs.LMProperties;
import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.LibVersionChecker;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Version;
import gov.nih.nlm.ncbi.ngs.error.LibraryIncompatibleVersionError;
import gov.nih.nlm.ncbi.ngs.error.LibraryLoadError;
import gov.nih.nlm.ncbi.ngs.error.LibraryNotFoundError;
import gov.nih.nlm.ncbi.ngs.error.cause.ConnectionProblemCause;
import gov.nih.nlm.ncbi.ngs.error.cause.DownloadDisabledCause;
import gov.nih.nlm.ncbi.ngs.error.cause.InvalidLibraryCause;
import gov.nih.nlm.ncbi.ngs.error.cause.JvmErrorCause;
import gov.nih.nlm.ncbi.ngs.error.cause.LibraryLoadCause;
import gov.nih.nlm.ncbi.ngs.error.cause.OutdatedJarCause;
import gov.nih.nlm.ncbi.ngs.error.cause.PrereleaseReqLibCause;
import gov.nih.nlm.ncbi.ngs.error.cause.UnsupportedArchCause;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

class LibManager
implements FileCreator {
    private boolean JUST_DO_SIMPLE_LOAD_LIBRARY = false;
    private boolean SEARCH_FOR_LIBRARY = true;
    private boolean AUTO_DOWNLOAD = true;
    private static final long SEARCH_LIB_FREQUENCY_INTERVAL = 604800000L;
    private static final long CACHE_LATEST_VERSION_INTERVAL = 604800000L;
    private Location[] locations;
    private Map<String, String> libraryVersions = new HashMap<String, String>();
    private HashMap<String, Version> latestVersions = new HashMap();
    private DownloadManager downloadManager;
    private String createdFileName;
    private LMProperties properties;
    boolean mocksEnabled = false;
    Map<Location, Version> mockLocationVersions;
    DownloadManager.DownloadResult mockDownloadStatus;
    Throwable mockLoadException;
    String mockLoadedLibraryVersion;

    LibManager(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null || stringArray == null) {
            throw new RuntimeException("Neither libs nor versions can be null");
        }
        if (stringArray2.length != stringArray.length) {
            throw new RuntimeException("Invalid library versions: must match number of libraries");
        }
        this.checkSystemProperties();
        this.locations = this.generateLocations();
        for (int j = 0; j < stringArray.length; ++j) {
            this.libraryVersions.put(stringArray[j], stringArray2[j]);
        }
        this.properties = new LMProperties(LibManager.detectJVM().intString(), this.libraryVersions);
        if (this.AUTO_DOWNLOAD) {
            this.downloadManager = new DownloadManager(this.properties);
        }
        if (!this.JUST_DO_SIMPLE_LOAD_LIBRARY && System.getProperty("vdb.deleteLibraries") != null) {
            for (String string : stringArray) {
                Logger.warning("Deleting all JNI libraries...");
                LibPathIterator.deleteLibraries(this, string);
            }
        }
    }

    private void checkSystemProperties() {
        String string;
        String string2 = System.getProperty("vdb.System.loadLibrary");
        if (string2 != null && string2.equals("1")) {
            Logger.warning("Smart DLL search and library download was disabled");
            this.JUST_DO_SIMPLE_LOAD_LIBRARY = true;
            this.AUTO_DOWNLOAD = false;
            this.SEARCH_FOR_LIBRARY = false;
            return;
        }
        String string3 = System.getProperty("vdb.System.noLibraryDownload");
        if (string3 != null && string3.equals("1")) {
            Logger.warning("DLL download was disabled");
            this.AUTO_DOWNLOAD = false;
        }
        if ((string = System.getProperty("vdb.System.noLibrarySearch")) != null && string.equals("1")) {
            Logger.warning("Search of installed DLL was disabled");
            this.SEARCH_FOR_LIBRARY = false;
        }
    }

    private Location[] generateLocations() {
        Location[] locationArray = Location.values();
        TreeSet<Location> treeSet = new TreeSet<Location>();
        if (this.JUST_DO_SIMPLE_LOAD_LIBRARY) {
            treeSet.addAll(Arrays.asList(locationArray));
            treeSet.remove((Object)Location.LIBPATH);
        }
        if (!this.AUTO_DOWNLOAD) {
            treeSet.add(Location.DOWNLOAD);
        }
        if (!this.SEARCH_FOR_LIBRARY) {
            TreeSet<Location> treeSet2 = new TreeSet<Location>(Arrays.asList(Location.CACHE, Location.LIBPATH, Location.DOWNLOAD));
            for (Location location : locationArray) {
                if (treeSet2.contains((Object)location)) continue;
                treeSet.add(location);
            }
        }
        if (treeSet.size() > 0) {
            Logger.info("Disabled locations: " + Arrays.toString(treeSet.toArray()));
        }
        Location[] locationArray2 = new Location[locationArray.length - treeSet.size()];
        int n = 0;
        for (Location location : locationArray) {
            if (treeSet.contains((Object)location)) continue;
            locationArray2[n++] = location;
        }
        assert (n == locationArray2.length);
        return locationArray2;
    }

    Location[] locations() {
        return this.locations;
    }

    @Override
    public BufferedOutputStream create(String string) {
        this.createdFileName = null;
        int n = 0;
        if (n < 2) {
            Object object;
            String string2;
            Location location = null;
            boolean bl = true;
            switch (n) {
                case 0: {
                    location = Location.NCBI_HOME;
                    bl = false;
                    break;
                }
            }
            LibPathIterator libPathIterator = new LibPathIterator(this, location, LibManager.mapLibraryName(string, bl), true);
            while (true) {
                if ((string2 = libPathIterator.nextName()) == null) {
                    return null;
                }
                Logger.fine("Trying to create " + string2 + "...");
                File file = new File(string2);
                try {
                    string2 = file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    Logger.warning(string2 + " : cannot getAbsolutePath " + securityException);
                    continue;
                }
                if (file.exists()) {
                    object = string2 + ".bak";
                    File file2 = new File((String)object);
                    String string3 = System.getProperty("os.name");
                    if (string3 != null && string3.startsWith("Win") && file2.exists()) {
                        Logger.fine("Trying to remove " + (String)object + " ...");
                        file2.delete();
                    }
                    Logger.finest("Trying to rename " + string2 + " to " + (String)object + " ...");
                    if (!file.renameTo(file2)) {
                        Logger.warning(string2 + ".renameTo(" + (String)object + ") failed");
                    }
                }
                object = null;
                try {
                    object = new FileOutputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.warning("Cannot open " + string2);
                    continue;
                }
                break;
            }
            this.createdFileName = string2;
            Logger.fine("Opened " + string2);
            return new BufferedOutputStream((OutputStream)object, 131072);
        }
        return null;
    }

    @Override
    public void done(boolean bl) {
        if (!bl) {
            this.createdFileName = null;
        }
    }

    void loadLibrary(String string) {
        Version version = this.getRequiredVersion(string);
        boolean bl = Arrays.asList(this.locations).contains((Object)Location.CACHE);
        Logger.fine("Searching for " + string + " library...");
        try {
            LibSearchResult libSearchResult = this.searchLibrary(string, version);
            if (libSearchResult.path == null) {
                throw new LibraryNotFoundError(string, "No installed library was found", libSearchResult.failCause);
            }
            Logger.fine("Found " + string + " library");
            String string2 = libSearchResult.path;
            Logger.info("Loading " + string + "...");
            try {
                if (!this.mocksEnabled) {
                    if (string2.startsWith(string)) {
                        System.loadLibrary(string2);
                    } else {
                        System.load(string2);
                    }
                } else if (this.mockLoadException != null) {
                    throw this.mockLoadException;
                }
            }
            catch (Throwable throwable) {
                if (libSearchResult.location != Location.DOWNLOAD) {
                    throw new LibraryLoadError(string, "Failed to load found library " + string2, new JvmErrorCause(throwable));
                }
                throw new LibraryLoadError(string, "No installed library was found and downloaded library '" + string2 + "' cannot be loaded", new JvmErrorCause(throwable), "Please install ngs and ncbi-vdb manually: https://github.com/ncbi/ngs/wiki/Downloads or write to \"sra-tools@ncbi.nlm.nih.gov\" if problems persist");
            }
            Logger.fine("Loaded " + string + " library");
            Logger.fine("Checking library " + string + " version...");
            String string3 = !this.mocksEnabled ? LibVersionChecker.getLoadedVersion(string) : this.mockLoadedLibraryVersion;
            if (string3 == null) {
                throw new LibraryLoadError(string, "Failed to retrieve loaded library's version", new InvalidLibraryCause());
            }
            Version version2 = new Version(string3);
            if (version2.compareTo(version) < 0 || !version2.isCompatible(version)) {
                Logger.fine("Library version is not compatible. Required: " + version.toSimpleVersion() + " loaded: " + version2.toSimpleVersion());
                LibraryLoadCause libraryLoadCause = libSearchResult.failCause;
                if (libSearchResult.location == Location.DOWNLOAD || libraryLoadCause == null) {
                    libraryLoadCause = version2.compareTo(version) < 0 ? new PrereleaseReqLibCause() : new OutdatedJarCause();
                }
                throw new LibraryIncompatibleVersionError(string, "Library is incompatible", string2, libraryLoadCause);
            }
            Logger.fine("Library " + string + " was loaded successfully. Version = " + version2.toSimpleVersion());
            if (bl) {
                this.properties.loaded(string, libSearchResult.version.toSimpleVersion(), string2);
                if (libSearchResult.location != Location.CACHE) {
                    this.properties.setLastSearch(string);
                }
            }
        }
        catch (LibraryLoadError libraryLoadError) {
            if (bl) {
                this.properties.notLoaded(string);
            }
            Logger.warning("Loading of " + string + " library failed");
            throw libraryLoadError;
        }
        finally {
            if (bl) {
                this.properties.store();
            }
        }
    }

    static String[] mapLibraryName(String string) {
        return LibManager.mapLibraryName(string, true);
    }

    static String[] mapLibraryName(String string, boolean bl) {
        String string2 = string;
        if (bl) {
            string2 = LibManager.libnameWithDataModel(string);
        }
        String string3 = System.getProperty("os.name");
        int n = 1;
        if (string3 != null && string3.equals("Mac OS X")) {
            n = 2;
        }
        int n2 = (string2 == null ? 1 : 2) * n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        if (string2 != null) {
            stringArray[n3++] = System.mapLibraryName(string2);
        }
        stringArray[n3++] = System.mapLibraryName(string);
        if (n == 2) {
            if (string2 != null) {
                stringArray[n3++] = string2 + ".dylib";
            }
            stringArray[n3++] = string + ".dylib";
        }
        return stringArray;
    }

    static Bits detectJVM() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String string2 = System.getProperty(string);
            Logger.finest(string + "=" + string2);
            if (string2 == null) continue;
            int n = string2.indexOf("64") >= 0 ? 64 : 32;
            Logger.finest(n + "-bit JVM");
            return n == 64 ? Bits.b64 : Bits.b32;
        }
        Logger.fine("Unknown-bit JVM");
        return Bits.bUNKNOWN;
    }

    private static String libnameWithDataModel(String string) {
        String string2 = null;
        switch (LibManager.detectJVM()) {
            case b64: {
                string2 = "-64";
                break;
            }
            case b32: {
                string2 = "-32";
            }
        }
        if (string2 != null) {
            string2 = string + string2;
        }
        return string2;
    }

    private static Location[] getLocationProperty() {
        String string = System.getProperty("vdb.loadLibraryLocations");
        if (string == null) {
            return null;
        }
        int n = 0;
        for (int j = 0; j < string.length(); ++j) {
            if ("PJCLNTWD".indexOf(string.charAt(j)) < 0) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Location[] locationArray = new Location[n];
        n = 0;
        block11: for (int j = 0; j < string.length(); ++j) {
            switch (string.charAt(j)) {
                case 'P': {
                    locationArray[n] = Location.CLASSPATH;
                    break;
                }
                case 'J': {
                    locationArray[n] = Location.NCBI_NGS_JAR_DIR;
                    break;
                }
                case 'C': {
                    locationArray[n] = Location.CACHE;
                    break;
                }
                case 'L': {
                    locationArray[n] = Location.LIBPATH;
                    break;
                }
                case 'N': {
                    locationArray[n] = Location.NCBI_HOME;
                    break;
                }
                case 'T': {
                    locationArray[n] = Location.TMP;
                    break;
                }
                case 'W': {
                    locationArray[n] = Location.CWD;
                    break;
                }
                case 'D': {
                    locationArray[n] = Location.DOWNLOAD;
                    break;
                }
                default: {
                    continue block11;
                }
            }
            ++n;
        }
        return locationArray;
    }

    private Version checkLibraryVersion(String string, String string2, boolean bl) {
        if (!bl && !LibManager.fileExists(string2)) {
            Logger.finer("File " + string2 + " not found");
            return null;
        }
        Version version = LibVersionChecker.getVersion(string, string2, bl);
        if (version == null) {
            Logger.fine("Cannot load or get library version: " + string2);
        }
        return version;
    }

    private static boolean fileExists(String string) {
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        Logger.finest(string + " does not exist");
        return false;
    }

    private Version getRequiredVersion(String string) {
        String string2 = this.libraryVersions.get(string);
        if (string2 == null) {
            throw new RuntimeException("Library '" + string + "' version was not specified");
        }
        return new Version(string2);
    }

    private Version getLatestVersion(String string) {
        if (this.latestVersions.containsKey(string)) {
            return this.latestVersions.get(string);
        }
        String string2 = this.properties.getLatestVersion(string, 604800000L);
        if (string2 == null && this.AUTO_DOWNLOAD) {
            string2 = this.downloadManager.getLatestVersion(string);
            if (string2 != null) {
                this.properties.setLatestVersion(string, string2);
            }
        } else {
            Logger.fine("Cached LatestVersion (" + string + ") = " + string2);
        }
        Version version = null;
        if (string2 != null) {
            version = new Version(string2);
        }
        this.latestVersions.put(string, version);
        return version;
    }

    private LibSearchResult searchLibrary(String string, Version version) {
        LibSearchResult libSearchResult = new LibSearchResult();
        block5: for (Location location : this.locations) {
            String string2;
            Object object;
            Logger.info("Checking " + string + " from " + (Object)((Object)location) + "...");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            boolean bl2 = !this.JUST_DO_SIMPLE_LOAD_LIBRARY;
            switch (location) {
                case LIBPATH: {
                    arrayList.add(string);
                    Object object2 = LibManager.libnameWithDataModel(string);
                    if (object2 != null) {
                        arrayList.add(object2);
                    }
                    bl = true;
                    break;
                }
                case CACHE: {
                    Object object2 = this.properties.get(string);
                    if (object2 == null) continue block5;
                    object = this.properties.getLastSeach(string);
                    bl2 = object == null || new Date().getTime() - ((Date)object).getTime() > 604800000L;
                    arrayList.add(object2);
                    bl = object2.startsWith(string);
                    break;
                }
                case DOWNLOAD: {
                    Object object2;
                    Logger.info("Downloading " + string + " from NCBI...");
                    if (!this.mocksEnabled) {
                        object2 = this.download(string);
                    } else {
                        if (this.mockDownloadStatus == null) {
                            throw new RuntimeException("mockDownloadStatus must be set when mocks enabled");
                        }
                        object2 = new LibDownloadResult();
                        object2.status = this.mockDownloadStatus;
                        object2.savedPath = "/some/path/" + string;
                    }
                    if (object2.status != DownloadManager.DownloadResult.SUCCESS) {
                        Logger.warning("Failed to download " + string + " from NCBI");
                        if (object2.status == DownloadManager.DownloadResult.UNSUPPORTED_OS) {
                            libSearchResult.failCause = new UnsupportedArchCause();
                            continue block5;
                        }
                        libSearchResult.failCause = new ConnectionProblemCause();
                        continue block5;
                    }
                    Logger.info("Downloaded " + string + " from NCBI");
                    Logger.fine("Checking " + string + " library...");
                    arrayList.add(object2.savedPath);
                    break;
                }
                default: {
                    Object object2 = LibManager.mapLibraryName(string);
                    Logger.finest("System.mapLibraryName(" + string + ") = " + object2[0]);
                    object = new LibPathIterator(location, (String[])object2);
                    while ((string2 = ((LibPathIterator)object).nextName()) != null) {
                        arrayList.add(string2);
                    }
                    break block0;
                }
            }
            boolean bl3 = false;
            object = arrayList.iterator();
            while (object.hasNext()) {
                boolean bl4;
                Version version2;
                string2 = (String)object.next();
                if (!this.mocksEnabled) {
                    version2 = this.checkLibraryVersion(string, string2, bl);
                } else {
                    if (this.mockLocationVersions == null) {
                        throw new RuntimeException("mockLocationVersions must be set when mocks enabled");
                    }
                    version2 = this.mockLocationVersions.get((Object)location);
                }
                if (version2 == null) continue;
                bl3 = true;
                boolean bl5 = bl4 = version2.isCompatible(version) && version2.compareTo(version) >= 0;
                if (libSearchResult.path == null || bl4 && version2.compareTo(libSearchResult.version) > 0 || !libSearchResult.versionFits) {
                    libSearchResult.versionFits = bl4;
                    libSearchResult.location = location;
                    libSearchResult.version = version2;
                    libSearchResult.path = string2;
                }
                if (!libSearchResult.versionFits || bl2) continue;
                break;
            }
            if (location == Location.DOWNLOAD && (!libSearchResult.versionFits || !bl3 && libSearchResult.path.equals(arrayList.get(0)))) {
                libSearchResult.versionFits = false;
                libSearchResult.location = location;
                libSearchResult.version = null;
                libSearchResult.path = (String)arrayList.get(0);
            }
            if (libSearchResult.version != null && libSearchResult.version.isCompatible(version) && ((object = this.getLatestVersion(string)) == null && libSearchResult.version.compareTo(version) >= 0 && !bl2 || object != null && libSearchResult.version.compareTo(version) >= 0)) break;
        }
        boolean bl = Arrays.asList(this.locations).contains((Object)Location.DOWNLOAD);
        if (libSearchResult.failCause == null && !bl) {
            libSearchResult.failCause = new DownloadDisabledCause();
        }
        return libSearchResult;
    }

    private LibDownloadResult download(String string) {
        if (!this.AUTO_DOWNLOAD) {
            throw new RuntimeException("AUTO_DOWNLOAD is disabled. This method should not be called");
        }
        LibDownloadResult libDownloadResult = new LibDownloadResult();
        Version version = this.getLatestVersion(string);
        if (version == null) {
            libDownloadResult.status = DownloadManager.DownloadResult.FAILED;
            return libDownloadResult;
        }
        libDownloadResult.status = this.downloadManager.downloadLib(this, string, version);
        if (libDownloadResult.status == DownloadManager.DownloadResult.SUCCESS) {
            libDownloadResult.savedPath = this.createdFileName;
            this.createdFileName = null;
            this.properties.saved(string, version.toSimpleVersion(), libDownloadResult.savedPath);
        }
        return libDownloadResult;
    }

    private boolean downloadKfg(String string) {
        Logger.finest("configuration download is disabled");
        return true;
    }

    private class LibDownloadResult {
        String savedPath = null;
        DownloadManager.DownloadResult status;

        private LibDownloadResult() {
        }
    }

    private class LibSearchResult {
        boolean versionFits = false;
        Location location = null;
        String path = null;
        Version version = null;
        LibraryLoadCause failCause = null;

        private LibSearchResult() {
        }
    }

    static enum Bits {
        b32,
        b64,
        bUNKNOWN;


        String intString() {
            switch (this) {
                case b32: {
                    return "32";
                }
            }
            return "64";
        }
    }

    static enum Location {
        CACHE,
        NCBI_HOME,
        LIBPATH,
        NCBI_NGS_JAR_DIR,
        CLASSPATH,
        CWD,
        TMP,
        DOWNLOAD;

    }
}

